package com.burhanstore.neonbubblequest.Utils.crequest

import android.app.Activity
import android.util.Log
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.lifecycle.lifecycleScope
import com.burhanstore.neonbubblequest.AppConst
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.callback.CoinCallBack
import com.burhanstore.neonbubblequest.Utils.network.ScNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.CoinAddResponse
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.launch

object CoinCredit {

    private var callback: CoinCallBack? = null
    fun setListener(listener: CoinCallBack) {
        callback = listener
    }


    fun daily_cAdd(
        activity: Activity,
        request_place: String? = null,
        config: String? = null,
        task_id: String? = null,
        isClick: Boolean = false,
        coin: String
    ) {


        val user = UserManager.getInstance(activity).getUser()
        if (user == null) {
            Toast.makeText(activity, "User not logged in!", Toast.LENGTH_SHORT).show()
            return
        }
        val json = JsonObject().apply {
            addProperty("action", "daily_coinadd")
            addProperty("user_id", user.u_id)
            addProperty("coin", coin)
            addProperty("day", task_id)
        }

        (activity as? ComponentActivity)?.lifecycleScope?.launch {
            ScNetworkAdapter.sendRequest(this, json, object : ScNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("CoinCredit", "Success: $response")

                    response?.let {
                        try {
                            val responseData = Gson().fromJson(it, CoinAddResponse::class.java)
                            activity.runOnUiThread {
                                update_coin(responseData.coin.toString())
                            }
                        } catch (e: Exception) {
                            Log.e("CoinCredit", "Parsing error", e)
                        }
                    }


                }

                override fun onError(code: Int, message: String?) {
                    Log.e("CoinCredit", "Error $code: $message")
                }

                override fun onException(exception: Exception) {
                    Log.e("CoinCredit", "Exception: ", exception)
                }
            })
        }


    }


    fun gameWinRewardAdd(
        activity: Activity,
        coin: String
    ) {

        val user = UserManager.getInstance(activity).getUser()
        if (user == null) {
            Toast.makeText(activity, "User not logged in!", Toast.LENGTH_SHORT).show()
            return
        }
        val json = JsonObject().apply {
            addProperty("action", "game_winrewardadd")
            addProperty("user_id", user.u_id)
            addProperty("coin", coin)
        }
        (activity as? ComponentActivity)?.lifecycleScope?.launch {
            ScNetworkAdapter.sendRequest(this, json, object : ScNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("CoinCredit", "Success: $response")

                    response?.let {
                        try {
                            val responseData = Gson().fromJson(it, CoinAddResponse::class.java)
                            activity.runOnUiThread {


                                AppConst.setString(
                                    activity, AppConst.USER_COIN, responseData.coin.toString()
                                )
                                DialogManager.dismissDialog()
                                update_coin(responseData.coin.toString())

                            }
                        } catch (e: Exception) {
                            Log.e("CoinCredit", "Parsing error", e)
                        }
                    }


                }

                override fun onError(code: Int, message: String?) {
                    Log.e("CoinCredit", "Error $code: $message")
                }

                override fun onException(exception: Exception) {
                    Log.e("CoinCredit", "Exception: ", exception)
                }
            })
        }


    }


    fun update_coin(coin: String) {
        Log.e("app run add", coin)
        callback?.onCoinReceived(coin)
    }


}
